//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Higher Order Functions
//:
//: ## Task:
//:
//: A "higher order function" is A function that accepts a function as an input parameter.
//:
//: Try and execute the code below. Pass in an array of integers.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func hasAnyMatches(list: [Int], condition: (Int) -> Bool) -> Bool {
    for item in list {
        if condition(item) {
            return true
        }
    }
    return false
}


//:
//: -------------------
//:
//: ## Task:
//:
//: To execute the function above we must create another function to be passed in as an input argument.
//:
//: An "argument" is the name given to the value passed into a function.
//:
//: Execute the code below and pay attension to the input parameter of the higher order function; the name of the function.
//:
//: -------------------
//:


func lessThanTen(number: Int) -> Bool {
    number < 10
}
var numbers = [20, 19, 7, 12]
if hasAnyMatches(list: numbers, condition: lessThanTen) {
    print("We have matches < than 10")
}


//:
//: -------------------
//:
//: ## Task:
//:
//: Write a function to compare if numbers are negative in any way and print a message to the console if you have any matches.
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: The `map` function is an instance method found on collection types.
//:
//: Without aid, try to execute the map function on the array below and convert the numeric list into strings.
//:
//: Use dot notation (escape is keyboard shortcut) to find the `map` function.
//:
//: -------------------
//:


//let strings = [20, 19, 7, 12]. // finish me
//print(strings)

// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: The `map` function is used below.
//:
//: As a "higher order function" it expects to recieve a function as an argument.
//:
//: Using our favorite algorithm, FizzBuzz, finish entering the text for the string values below. Execute the code and ensure it functions as expected.
//:
//: -------------------
//:


let convertedValues: [String] = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15].map ({ number in
    let isDivisibleBy3 = number % 3 == 0
    let isDivisibleBy5 = number % 5 == 0
    switch (isDivisibleBy3, isDivisibleBy5) {
    case (true, true):
        return "" // "Fizz" goes here
    case (true, false):
        return ""
    case (false, true):
        return ""
    case (false, false):
        return "\(number)"
    }
})
print(convertedValues)


//:
//: -------------------
//:
//: ## Task:
//:
//: The `map` function is used below.
//:
//: Several higher order functions exist on collection types.
//:
//: Without aid, try to finish the code to remove all items that match a condition you need to write.
//:
//: -------------------
//:

var list = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
let first: Int? = list.first { number in
    return number % 3 == 0
}

list.forEach { number in
    print(number)
}

let containsTheValue: Bool = list.contains { number in
    return number % 3 == 0
}

list.removeAll(where: { number in
    <#code#>
})
print(list)


//:
//: -------------------
//:
//: The `reduce` function is used below.
//:
//: It will apply a closure to each item in the array in order to reduce the array down to one individual value.
//:
//: -------------------
//:


let reducedUsingAddition = list.reduce(0, { partialResult, number in
    return partialResult + number
})


//:
//: -------------------
//:
//: The `compactMap` function is used below.
//:
//: It will apply a closure to remove each value from its output when `nil` is found.
//:
//: -------------------
//:


let stringNumbers = ["1", "2", "3", "four", "5"]
let convertedNumbers: [Int] = stringNumbers.compactMap { Int($0) }
print(convertedNumbers)


//:
//: -------------------
//:
//: ## Task:
//:
//: The `compactMap` function is used below.
//:
//: For each number in the closure provided to the `compactMap` function convert it to an `Int` if possible.
//:
//: -------------------
//:


let textInput = ["1", "2", "3", "four", "5"]
let refinedInput: [Int] = stringNumbers.compactMap { number in
    return // finish me
}
print(refinedInput)


//:
//: -------------------
//:
//: The `compactMap` function is used with the FizzBuzz algorithm below.
//:
//: -------------------
//:


let fizzBuzzedNoNumbers: [String] = list.compactMap ({ number in
    let isDivisibleBy3 = number % 3 == 0
    let isDivisibleBy5 = number % 5 == 0
    switch (isDivisibleBy3, isDivisibleBy5) {
    case (true, true):
        return "FizzBuzz"
    case (true, false):
        return "Fizz"
    case (false, true):
        return "Buzz"
    case (false, false):
        return nil
    }
})
print(fizzBuzzedNoNumbers)


//:
//: -------------------
//:
//: ## Task:
//:
//: Use `compactMap` function to apply the FizzBuzz algorithm but only include the numbers not fizz buzzed in the result.
//:
//: -------------------
//:


// write code here











